unit aspxDelphiWCL.DateSelector;

{
Copyright:  aspxDelphi.net All rights reserved. Use freely.

Zarko Gajic
http://aspxdelphi.net
http://delphi.about.com

}

interface

uses
  aspxDelphiWCL.Common, aspxDelphiWCL.Designer,
  System.ComponentModel,System.ComponentModel.Design,
  System.Web.UI, System.Web.UI.WebControls, System.Globalization,
  System.Text, System.Collections.Specialized, System.Web.UI.Design;


type
  SelectedDateChangedEventHandler = procedure(e : System.EventArgs) of object;

	[
	DefaultProperty('SelectedDate')
	,DefaultEvent('SelectedDateChanged')
	,DesignerAttribute(typeof(aspxDelphiWCL.Designer.Designer))
	,ToolboxData('<{0}:DateSelector runat=server></{0}:DateSelector>')
	]
  DateSelector = class(System.Web.UI.WebControls.WebControl, INamingContainer, IPostBackDataHandler)
  strict private
    FSelectedDateChanged : SelectedDateChangedEventHandler;

    FSelectedDate: DateTime;
    FYearSpan : integer;

    yearPicker : DropDownList;
    monthPicker : DropDownList;
    dayPicker : DropDownList;

    procedure CreateDateCombos;
    procedure RecreateYearPicker(const curYear : integer);
    function scriptString : string;
  strict protected

    procedure CreateChildControls; override;
    procedure OnInit(e : EventArgs); override;
    procedure OnPreRender(e : System.EventArgs); override;
    procedure AddAttributesToRender(writer : HtmlTextWriter); override;

  public
    constructor Create;
    function get_Controls :  System.Web.UI.ControlCollection; override;

    function LoadPostData(postDataKey : string; postCollection: NameValueCollection) : boolean;
    procedure RaisePostDataChangedEvent;
  protected
    procedure OnSelectedDateChanged;
  published
    //property getters setters
    function getYearSpan: integer;
    procedure setYearSpan(const Value: integer);
    function getDate: DateTime;
    procedure setDate(const Value: DateTime);

    //properties
    [Category('Appearance')]
    property SelectedDate : DateTime read getDate write setDate;

    [DefaultValue(10),Category('Appearance')]
    property YearSpan : integer read getYearSpan write setYearSpan;

    //events
    property SelectedDateChanged : SelectedDateChangedEventHandler add FSelectedDateChanged remove FSelectedDateChanged;
  end;

implementation


{$REGION 'ComboCalendar implementation'}

{$REGION 'Constructor'}
constructor DateSelector.Create;
begin
  inherited;
  FYearSpan := 10;
  FSelectedDate := DateTime.Today;
end;
{$ENDREGION}

{$REGION 'Property geters seters'}
function DateSelector.getDate: DateTime;
begin
  Result := FSelectedDate;
end;

procedure DateSelector.setDate(const Value: DateTime);
begin
  if Value <> FSelectedDate then
  begin
    FSelectedDate := Value;
    EnsureChildControls;

    yearPicker.SelectedValue := Value.Year.toString;
    monthPicker.SelectedValue := Value.Month.toString;
    RecreateYearPicker(SelectedDate.Year);
  end;
end;

function DateSelector.getYearSpan: integer;
begin
  Result := FYearSpan;
end;

procedure DateSelector.setYearSpan(const Value: integer);
begin
  FYearSpan := Value;
  EnsureChildControls;

  RecreateYearPicker(SelectedDate.Year);
end;
{$ENDREGION}

{$REGION 'init, Load, Render, ...'}
procedure DateSelector.OnInit(e: EventArgs);
begin
  inherited;

  if not Common.IsDesignTime(Page) then
    Page.RegisterRequiresPostBack(self);
end;

function DateSelector.scriptString: string;
begin
  with StringBuilder.Create do
  begin
    Append('<script language="javascript">');
    Append('function DateSelector_isLeapYear(year)');
    Append('{');
    Append('ily = false;');
    Append('if (year % 400 == 0){ ily = true; }');
    Append('else if ( (year % 4 == 0) && (year % 100 != 0 )) { ily=true; }');
    Append('return ily;');
    Append('}');
    Append('');
    Append('function DateSelector_doOnChange(cbo, dmy)');
    Append('{');
    Append('if (cbo.tagName.toLowerCase() != "select") return false;');
    Append('var cmdDay; var cmdMonth; var cmdYear;');
    Append('switch(dmy)');
    Append('{') ;
    Append('case "m":');
    Append('cmdDay = document.getElementById(cbo.getAttribute("myDay"));');
    Append('cmdMonth = cbo;');
    Append('cmdYear = document.getElementById(cbo.getAttribute("myYear"));');
    Append('break;');
    Append('case "y":');
    Append('cmdDay = document.getElementById(cbo.getAttribute("myDay"));');
    Append('cmdMonth = document.getElementById(cbo.getAttribute("myMonth"));');
    Append('cmdYear = cbo;');
    Append('break;');
    Append('}');
    Append('var day = cmdDay.options[cmdDay.selectedIndex].value;');
    Append('var month = cmdMonth.options[cmdMonth.selectedIndex].value;');
    Append('var year = cmdYear.options[cmdYear.selectedIndex].value;');
    Append('if (cmdDay.options.length < 31) ');
    Append('{');
    Append('var j = cmdDay.options.length;') ;
    Append('for (var i=j+1;i<32;i++) ');
    Append('{') ;
    Append('var oOption = document.createElement("OPTION");') ;
    Append('cmdDay.options.add(oOption);');
    Append('oOption.text = i;');
    Append('oOption.value = i;');
    Append('}') ;
    Append('}');
    Append('if ((month == 4) || (month == 6) || (month == 9) || (month == 11))');
    Append('{');
    Append('if (cmdDay.options.length == 31){cmdDay.options.remove(30);}');
    Append('}');
    Append('else if (month == 2)');
    Append('{');
    Append('if (cmdDay.options.length == 31){cmdDay.options[30] = null;}');
    Append('if (cmdDay.options.length == 30){cmdDay.options[29] = null;}');
    Append('if (!DateSelector_isLeapYear(year)){if (cmdDay.options.length == 29){cmdDay.options[28] = null;}}');
    Append('}');
    Append('if (cmdDay.selectedIndex == -1){cmdDay.selectedIndex = -1;}');
    Append('}');
    Append('</script>');

    Result := ToString;
  end;
end;

procedure DateSelector.OnPreRender(e: System.EventArgs);
var
  i: integer;
begin
  inherited;

  dayPicker.Items.Clear;
  for i := 1 to DateTime.DaysInMonth(SelectedDate.Year, SelectedDate.Month) do dayPicker.Items.Add(i.ToString);
  dayPicker.SelectedValue := SelectedDate.Day.ToString;

  if (Not Page.IsClientScriptBlockRegistered('DateSelectorClientScript')) Then
    Page.RegisterClientScriptBlock('DateSelectorClientScript', scriptString);
end;

procedure DateSelector.AddAttributesToRender(writer: HtmlTextWriter);
begin
  inherited;

  //dont break lines between combos
  writer.AddStyleAttribute('white-space', 'nowrap');

  dayPicker.Attributes.Add('myMonth', monthPicker.ClientID);
  dayPicker.Attributes.Add('myYear', yearPicker.ClientID);

  monthPicker.Attributes.Add('onchange', 'DateSelector_doOnChange(this, "m");');
  monthPicker.Attributes.Add('myDay', dayPicker.ClientID);
  monthPicker.Attributes.Add('myYear', yearPicker.ClientID);

  yearPicker.Attributes.Add('onchange', 'DateSelector_doOnChange(this, "y");');
  yearPicker.Attributes.Add('myDay', dayPicker.ClientID);
  yearPicker.Attributes.Add('myMonth', monthPicker.ClientID);
end;

{$ENDREGION}

{$REGION 'CreateChildControls and the rest'}

procedure DateSelector.RecreateYearPicker(const curYear : integer);
var
  i : integer;
begin
  yearPicker.Items.Clear;
  i := (curYear - YearSpan);
  while (i <= (curYear + YearSpan)) do
  begin
    yearPicker.Items.Add(i.ToString);
    if (curYear = i) then yearPicker.SelectedIndex := (i - (curYear - YearSpan));
    i := i + 1;
  end;
end;

procedure DateSelector.CreateDateCombos;
var
  i : integer;
  li : ListItem;
begin
 dayPicker := DropDownList.Create();
 dayPicker.ID := 'd';
 dayPicker.EnableViewState := false;
 for i := 1 to 31 do dayPicker.Items.Add(i.ToString);
 dayPicker.SelectedValue := SelectedDate.Day.ToString;

 monthPicker := DropDownList.Create;
 monthPicker.ID := 'm';

 for i := 0 to -1 +  System.Array(CultureInfo.CurrentCulture.DateTimeFormat.MonthNames).Length do
 begin
   if (i = 12) AND (CultureInfo.CurrentCulture.DateTimeFormat.MonthNames[i] = System.String.empty) then
     break;

   li := ListItem.Create(CultureInfo.CurrentCulture.DateTimeFormat.MonthNames[i], Convert.toString(i + 1));
   monthPicker.Items.Add(li);
 end;
 monthPicker.SelectedValue := SelectedDate.Month.ToString;

 yearPicker := DropDownList.Create;
 yearPicker.ID := 'y';

 ChildControlsCreated := true;
 SelectedDate := SelectedDate;
end;

procedure DateSelector.CreateChildControls;
var
  dmy : string;
begin
  inherited;

  Controls.Clear;

  CreateDateCombos;

  dmy := CultureInfo.CurrentCulture.DateTimeFormat.ShortDatePattern.Substring(1).toLower();

  if dmy = 'd' then
  begin
    Controls.Add(dayPicker);
    Controls.Add(monthPicker);
    Controls.Add(yearPicker);
  end
  else if dmy = 'm' then
  begin
    Controls.Add(monthPicker);
    Controls.Add(dayPicker);
    Controls.Add(yearPicker);
  end
  else if dmy = 'y' then
  begin
    Controls.Add(yearPicker);
    Controls.Add(monthPicker);
    Controls.Add(dayPicker);
  end
  else
  begin
    Controls.Add(dayPicker);
    Controls.Add(monthPicker);
    Controls.Add(yearPicker);
  end;

  ChildControlsCreated := true;
  YearSpan := 10;

end;

function DateSelector.get_Controls : System.Web.UI.ControlCollection;
begin
  EnsureChildControls;
  Result := inherited get_Controls;
end;

{$ENDREGION}

{$REGION 'IPostBackDataHandler'}
function DateSelector.LoadPostData(postDataKey: string; postCollection: NameValueCollection): boolean;
var
  Day, Month, Year : integer;
  newDate : DateTime;
begin
  EnsureChildControls;

  Day := Convert.ToInt32(dayPicker.SelectedItem.Value);
  Month := Convert.ToInt32(monthPicker.SelectedItem.Value);
  Year := Convert.ToInt32(yearPicker.SelectedItem.Value);

  newDate := DateTime.Create(Year, Month, Day);

  if newDate <> SelectedDate then //Call the RaisePostDataChangedEvent
  begin
    SelectedDate := newDate;
    Result := true;
  end
  else
    Result := false;
end;

procedure DateSelector.RaisePostDataChangedEvent;
begin
  OnSelectedDateChanged;
end;

{$ENDREGION}

{$REGION 'Events'}
procedure DateSelector.OnSelectedDateChanged;
begin
  if Assigned(FSelectedDateChanged) then
    FSelectedDateChanged(EventArgs.Empty);
end;
{$ENDREGION}

{$ENDREGION}





end.
